//
//  Sequencer.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//

public protocol MIDINoteProtocol {
    
    /// note as an 8-bit MIDI code
    var midiCode: UInt8 { get }
}

public protocol TrackProtocol {
    associatedtype NoteType : MIDINoteProtocol
    
    /// The kind of instrument that the track sequences
    var instrument: Instrument.Kind { get }
    
    /// Number of beats contained in the sequence
    var length: Int { get }
    
    /// MIDI code for the sequence frame
    func note(for frame: Int) -> NoteType
}



// The Wizard has provided a MIDI Notes implementation for you.
public enum MIDINotes : UInt8, MIDINoteProtocol {
    case rest = 0
    
    case c1  = 24
    case cs1 = 25
    case d1  = 26
    case ds1 = 27
    case e1  = 28
    case f1  = 29
    case fs1 = 30
    case g1  = 31
    case gs1 = 32
    case a1  = 33
    case as1 = 34
    case b1  = 35
    
    case c2  = 36
    case cs2 = 37
    case d2  = 38
    case ds2 = 39
    case e2  = 40
    case f2  = 41
    case fs2 = 42
    case g2  = 43
    case gs2 = 44
    case a2  = 45
    case as2 = 46
    case b2  = 47
    
    case c3  = 48
    case cs3 = 49
    case d3  = 50
    case ds3 = 51
    case e3  = 52
    case f3  = 53
    case fs3 = 54
    case g3  = 55
    case gs3 = 56
    case a3  = 57
    case as3 = 58
    case b3  = 59
    
    case c4  = 60
    case cs4 = 61
    case d4  = 62
    case ds4 = 63
    case e4  = 64
    case f4  = 65
    case fs4 = 66
    case g4  = 67
    case gs4 = 68
    case a4  = 69
    case as4 = 70
    case b4  = 71
    
    case c5  = 72
    case cs5 = 73
    case d5  = 74
    case ds5 = 75
    case e5  = 76
    case f5  = 77
    case fs5 = 78
    case g5  = 79
    case gs5 = 80
    case a5  = 81
    case as5 = 82
    case b5  = 83
    
    /// note as an 8-bit MIDI code
    public var midiCode: UInt8 {
        return self.rawValue
    }
}


// TODO: Build an implementation of TrackProtocol
//
// public class Track : TrackProtocol
